/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.crafting.CustomRecipesReloadedEvent;
import com.minecolonies.coremod.colony.crafting.RecipeAnalyzer;
import com.minecolonies.coremod.compatibility.jei.CompostRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.FishermanRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.GenericRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.HerderRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.transfer.BrewingCraftingGuiHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.CraftingGuiHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.FurnaceCraftingGuiHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.PrivateBrewingTeachingTransferHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.PrivateCraftingTeachingTransferHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.PrivateSmeltingTeachingTransferHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private final List<JobBasedRecipeCategory<?>> categories = new ArrayList();
    private boolean recipesLoaded;
    private WeakReference<IJeiRuntime> weakRuntime;

    public JEIPlugin() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, CustomRecipesReloadedEvent.class, this::onCustomRecipesReloaded);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("minecolonies");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IModIdHelper modIdHelper = jeiHelpers.getModIdHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FishermanRecipeCategory(guiHelper)});
        this.categories.clear();
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            HashMap<JobEntry, GenericRecipeCategory> craftingCategories = new HashMap<JobEntry, GenericRecipeCategory>();
            for (Supplier<IBuildingModule> producer : building.getModuleProducers()) {
                ICraftingBuildingModule crafting;
                IJob<?> job;
                IBuildingModule module = producer.get();
                if (module instanceof ICraftingBuildingModule && (job = (crafting = (ICraftingBuildingModule)module).getCraftingJob()) != null) {
                    GenericRecipeCategory category = (GenericRecipeCategory)craftingCategories.get((Object)job.getJobRegistryEntry());
                    if (category == null) {
                        category = new GenericRecipeCategory(building, job, crafting, guiHelper, modIdHelper);
                        craftingCategories.put(job.getJobRegistryEntry(), category);
                    } else {
                        category.addModule(crafting);
                    }
                }
                if (!(module instanceof AnimalHerdingModule)) continue;
                AnimalHerdingModule herding = (AnimalHerdingModule)module;
                this.registerCategory(registration, new HerderRecipeCategory(building, herding.getHerdingJob(), herding, guiHelper));
            }
            for (GenericRecipeCategory category : craftingCategories.values()) {
                this.registerCategory(registration, category);
            }
        }
    }

    private void registerCategory(@NotNull IRecipeCategoryRegistration registration, @NotNull JobBasedRecipeCategory<?> category) {
        this.categories.add(category);
        registration.addRecipeCategories(new IRecipeCategory[]{category});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.blockHutComposter.m_5456_()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("com.minecolonies.coremod.jei." + ModJobs.COMPOSTER_ID.m_135815_())});
        if (!this.recipesLoaded && !Minecraft.m_91087_().m_91090_()) {
            return;
        }
        this.populateRecipes(RecipeAnalyzer.buildVanillaRecipesMap(Minecraft.m_91087_().f_91073_.m_7465_(), (Level)Minecraft.m_91087_().f_91073_), (arg_0, arg_1) -> ((IRecipeRegistration)registration).addRecipes(arg_0, arg_1));
        this.recipesLoaded = true;
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.blockBarrel), new ResourceLocation[]{CompostRecipe.ID});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.blockHutComposter), new ResourceLocation[]{CompostRecipe.ID});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.blockHutFisherman), new ResourceLocation[]{ModJobs.FISHERMAN_ID});
        for (JobBasedRecipeCategory<?> category : this.categories) {
            registration.addRecipeCatalyst(category.getCatalyst(), new ResourceLocation[]{category.getUid()});
        }
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateCraftingTeachingTransferHandler(registration.getTransferHelper()), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateSmeltingTeachingTransferHandler(registration.getTransferHelper()), VanillaRecipeCategoryUid.FURNACE);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateBrewingTeachingTransferHandler(registration.getTransferHelper()), VanillaRecipeCategoryUid.BREWING);
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        new CraftingGuiHandler(this.categories).register(registration);
        new FurnaceCraftingGuiHandler(this.categories).register(registration);
        new BrewingCraftingGuiHandler(this.categories).register(registration);
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        this.weakRuntime = new WeakReference<IJeiRuntime>(jeiRuntime);
    }

    private void populateRecipes(@NotNull Map<CraftingType, List<IGenericRecipe>> vanilla, @NotNull BiConsumer<Collection<?>, ResourceLocation> registrar) {
        registrar.accept(CompostRecipeCategory.findRecipes(), CompostRecipe.ID);
        registrar.accept(FishermanRecipeCategory.findRecipes(), ModJobs.FISHERMAN_ID);
        for (JobBasedRecipeCategory<?> category : this.categories) {
            try {
                registrar.accept(category.findRecipes(vanilla), category.getUid());
            }
            catch (Exception e) {
                Log.getLogger().error("Failed to process recipes for " + category.getTitle(), (Throwable)e);
            }
        }
    }

    private void onCustomRecipesReloaded(@NotNull CustomRecipesReloadedEvent event) {
        IJeiRuntime runtime;
        if (this.weakRuntime != null && !this.recipesLoaded && !this.categories.isEmpty() && (runtime = (IJeiRuntime)this.weakRuntime.get()) != null) {
            IRecipeManager jeiManager = runtime.getRecipeManager();
            this.populateRecipes(RecipeAnalyzer.buildVanillaRecipesMap(Minecraft.m_91087_().f_91073_.m_7465_(), (Level)Minecraft.m_91087_().f_91073_), (list, uid) -> {
                for (Object recipe : list) {
                    jeiManager.addRecipe(recipe, uid);
                }
            });
        }
        this.recipesLoaded = true;
    }
}

